"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryTesterFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("./i18n");
var _query_tester = require("./query_tester");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QueryTesterFlyout = ({
  onClose
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "aria-labelledby": "queryTesterFlyoutTitle",
    ownFocus: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "queryTesterFlyoutTitle"
  }, _i18n.QUERY_TESTER_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_query_tester.QueryTester, null)));
};
exports.QueryTesterFlyout = QueryTesterFlyout;