"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.modelInput = modelInput;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * This is the entrypoint of the graph.
 * Any logic that should affect the state based on for example the invoke input should be done here.
 *
 * @param logger - The scoped logger
 * @param state - The current state of the graph
 */
function modelInput({
  logger,
  state
}) {
  logger.debug(() => `${_constants.NodeType.MODEL_INPUT}: Node state:\n${JSON.stringify(state, null, 2)}`);
  const hasRespondStep = state.isStream && state.provider === 'bedrock';
  return {
    hasRespondStep,
    lastNode: _constants.NodeType.MODEL_INPUT
  };
}