"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuntimeState = exports.useCurrentDataView = exports.useAdHocDataViews = exports.createRuntimeStateManager = exports.RuntimeStateProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createRuntimeStateManager = () => ({
  currentDataView$: new _rxjs.BehaviorSubject(undefined),
  adHocDataViews$: new _rxjs.BehaviorSubject([])
});
exports.createRuntimeStateManager = createRuntimeStateManager;
const useRuntimeState = stateSubject$ => {
  const [stateObservable$] = (0, _react.useState)(() => stateSubject$.pipe((0, _rxjs.skip)(1)));
  return (0, _useObservable.default)(stateObservable$, stateSubject$.getValue());
};
exports.useRuntimeState = useRuntimeState;
const runtimeStateContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const RuntimeStateProvider = ({
  currentDataView,
  adHocDataViews,
  children
}) => {
  const runtimeState = (0, _react.useMemo)(() => ({
    currentDataView,
    adHocDataViews
  }), [adHocDataViews, currentDataView]);
  return /*#__PURE__*/_react.default.createElement(runtimeStateContext.Provider, {
    value: runtimeState
  }, children);
};
exports.RuntimeStateProvider = RuntimeStateProvider;
const useRuntimeStateContext = () => {
  const context = (0, _react.useContext)(runtimeStateContext);
  if (!context) {
    throw new Error('useRuntimeStateContext must be used within a RuntimeStateProvider');
  }
  return context;
};
const useCurrentDataView = () => useRuntimeStateContext().currentDataView;
exports.useCurrentDataView = useCurrentDataView;
const useAdHocDataViews = () => useRuntimeStateContext().adHocDataViews;
exports.useAdHocDataViews = useAdHocDataViews;