"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAggregatedDatasetPaginatedResults = getAggregatedDatasetPaginatedResults;
var _utils = require("../../../common/utils");
var _utils2 = require("../../utils");
var _queries = require("../../utils/queries");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SIZE_LIMIT = 10000;
async function getAggregatedDatasetPaginatedResults(options) {
  var _response$aggregation, _response$aggregation2, _response$aggregation3, _response$aggregation4;
  const {
    esClient,
    index,
    query,
    start,
    end,
    after,
    prevResults = []
  } = options;
  const datasetQualityESClient = (0, _utils2.createDatasetQualityESClient)(esClient);
  const aggs = afterKey => ({
    datasets: {
      composite: {
        ...(afterKey ? {
          after: afterKey
        } : {}),
        size: SIZE_LIMIT,
        sources: [{
          dataset: {
            terms: {
              field: '_index'
            }
          }
        }]
      }
    }
  });
  const bool = {
    ...query,
    filter: [...(query !== null && query !== void 0 && query.filter ? Array.isArray(query.filter) ? query.filter : [query.filter] : []), ...[...(0, _queries.rangeQuery)(start, end)]]
  };
  const response = await datasetQualityESClient.search({
    index,
    size: 0,
    query: {
      bool
    },
    aggs: aggs(after),
    ignore_unavailable: true
  });
  const currResults = (_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.datasets.buckets.map(bucket => ({
    dataset: bucket.key.dataset,
    count: bucket.doc_count
  }))) !== null && _response$aggregation !== void 0 ? _response$aggregation : [];
  const results = [...prevResults, ...currResults];
  if ((_response$aggregation3 = response.aggregations) !== null && _response$aggregation3 !== void 0 && _response$aggregation3.datasets.after_key && ((_response$aggregation4 = response.aggregations) === null || _response$aggregation4 === void 0 ? void 0 : _response$aggregation4.datasets.buckets.length) === SIZE_LIMIT) {
    var _response$aggregation5;
    return getAggregatedDatasetPaginatedResults({
      esClient,
      index,
      start,
      end,
      after: ((_response$aggregation5 = response.aggregations) === null || _response$aggregation5 === void 0 ? void 0 : _response$aggregation5.datasets.after_key) || after,
      prevResults: results
    });
  }
  return Object.entries(results.reduce((acc, curr) => {
    var _acc$dataset;
    const dataset = (0, _utils.extractIndexNameFromBackingIndex)(curr.dataset);
    acc[dataset] = ((_acc$dataset = acc[dataset]) !== null && _acc$dataset !== void 0 ? _acc$dataset : 0) + curr.count;
    return acc;
  }, {})).map(([dataset, count]) => ({
    dataset,
    count
  }));
}