"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoreVersionedRouter = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _core_versioned_route = require("./core_versioned_route");
var _util = require("../util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */

class CoreVersionedRouter {
  static from({
    router,
    log,
    defaultHandlerResolutionStrategy,
    isDev,
    useVersionResolutionStrategyForInternalPaths
  }) {
    return new CoreVersionedRouter(router, log, defaultHandlerResolutionStrategy, isDev, useVersionResolutionStrategyForInternalPaths);
  }
  constructor(router, log, defaultHandlerResolutionStrategy = 'oldest', isDev = false, useVersionResolutionStrategyForInternalPaths = []) {
    (0, _defineProperty2.default)(this, "routes", new Set());
    (0, _defineProperty2.default)(this, "useVersionResolutionStrategyForInternalPaths", new Map());
    (0, _defineProperty2.default)(this, "pluginId", void 0);
    (0, _defineProperty2.default)(this, "registerVersionedRoute", routeMethod => options => {
      const route = _core_versioned_route.CoreVersionedRoute.from({
        router: this.router,
        log: this.log,
        method: routeMethod,
        path: options.path,
        options: {
          ...options,
          defaultHandlerResolutionStrategy: this.defaultHandlerResolutionStrategy,
          useVersionResolutionStrategyForInternalPaths: this.useVersionResolutionStrategyForInternalPaths,
          isDev: this.isDev
        }
      });
      this.routes.add(route);
      return route;
    });
    (0, _defineProperty2.default)(this, "get", this.registerVersionedRoute('get'));
    (0, _defineProperty2.default)(this, "delete", this.registerVersionedRoute('delete'));
    (0, _defineProperty2.default)(this, "post", this.registerVersionedRoute('post'));
    (0, _defineProperty2.default)(this, "patch", this.registerVersionedRoute('patch'));
    (0, _defineProperty2.default)(this, "put", this.registerVersionedRoute('put'));
    this.router = router;
    this.log = log;
    this.defaultHandlerResolutionStrategy = defaultHandlerResolutionStrategy;
    this.isDev = isDev;
    this.pluginId = this.router.pluginId;
    for (const path of useVersionResolutionStrategyForInternalPaths) {
      this.useVersionResolutionStrategyForInternalPaths.set(path, true);
    }
  }
  getRoutes() {
    return [...this.routes].map(route => {
      return {
        path: (0, _util.getRouteFullPath)(this.router.routerPath, route.path),
        method: route.method,
        options: (0, _lodash.omit)(route.options, 'path'),
        handlers: route.getHandlers(),
        isVersioned: true
      };
    });
  }
}
exports.CoreVersionedRouter = CoreVersionedRouter;