"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.documentsUpdateInit = void 0;
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var _helpers = require("../../../model/helpers");
var _core = require("../../../core");
var _utils = require("../../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const documentsUpdateInit = (state, res, context) => {
  if (Either.isLeft(res)) {
    (0, _helpers.throwBadResponse)(state, res);
  }
  const types = context.types.map(type => context.typeRegistry.getType(type));
  const logs = [...state.logs];
  const excludeFilterHooks = Object.fromEntries(context.types.map(name => context.typeRegistry.getType(name)).filter(type => !!type.excludeOnUpgrade).map(type => [type.name, type.excludeOnUpgrade]));
  const outdatedDocumentsQuery = (0, _utils.getOutdatedDocumentsQuery)({
    types
  });
  const transformRawDocs = (0, _utils.createDocumentTransformFn)({
    serializer: context.serializer,
    documentMigrator: context.documentMigrator
  });
  const commonState = {
    logs,
    excludeOnUpgradeQuery: (0, _core.buildExcludeUnusedTypesQuery)(context.typeRegistry.getLegacyTypes()),
    excludeFromUpgradeFilterHooks: excludeFilterHooks,
    outdatedDocumentsQuery,
    transformRawDocs
  };

  // index was previously using the v2 algo, we skip compat check and jump to next stage
  if (state.previousAlgorithm === 'v2') {
    return {
      ...state,
      ...commonState,
      controlState: 'SET_DOC_MIGRATION_STARTED'
    };
  }
  const versionCheck = (0, _utils.checkVersionCompatibility)({
    mappings: state.previousMappings,
    types,
    source: 'docVersions',
    deletedTypes: context.deletedTypes
  });
  logs.push({
    level: 'info',
    message: `DOCUMENTS_UPDATE_INIT: doc version check result: ${versionCheck.status}`
  });
  switch (versionCheck.status) {
    // app version is greater than the index mapping version.
    // scenario of an upgrade: we need to run the document migration.
    case 'greater':
      return {
        ...state,
        ...commonState,
        controlState: 'SET_DOC_MIGRATION_STARTED'
      };
    // app version and index mapping version are the same.
    // either application upgrade without model change, or a simple reboot on the same version.
    // There's nothing to do here, as documents are already at the same version.
    case 'equal':
      return {
        ...state,
        logs,
        controlState: 'DONE'
      };
    // app version is lower than the index mapping version.
    // Should only occur in case of rollback.
    // For now, we don't do anything.
    case 'lesser':
      return {
        ...state,
        logs,
        controlState: 'DONE'
      };
    // conflicts: version for some types are greater, some are lower
    // shouldn't occur in any normal scenario - cannot recover
    case 'conflict':
    default:
      return {
        ...state,
        logs,
        controlState: 'FATAL',
        reason: 'Model version conflict: inconsistent higher/lower versions'
      };
  }
};
exports.documentsUpdateInit = documentsUpdateInit;