"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createContext = void 0;
var _coreSavedObjectsBaseServerInternal = require("@kbn/core-saved-objects-base-server-internal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Create the context object that will be used for this index migration.
 */
const createContext = ({
  kibanaVersion,
  types,
  docLinks,
  migrationConfig,
  documentMigrator,
  elasticsearchClient,
  indexPrefix,
  typeRegistry,
  serializer,
  nodeRoles,
  esCapabilities
}) => {
  return {
    migrationConfig,
    documentMigrator,
    kibanaVersion,
    indexPrefix,
    types,
    typeVirtualVersions: (0, _coreSavedObjectsBaseServerInternal.getVirtualVersionMap)(types.map(type => typeRegistry.getType(type))),
    elasticsearchClient,
    typeRegistry,
    serializer,
    maxRetryAttempts: migrationConfig.retryAttempts,
    migrationDocLinks: docLinks.links.kibanaUpgradeSavedObjects,
    deletedTypes: typeRegistry.getLegacyTypes(),
    batchSize: migrationConfig.batchSize,
    discardCorruptObjects: Boolean(migrationConfig.discardCorruptObjects),
    nodeRoles,
    esCapabilities
  };
};
exports.createContext = createContext;