"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilesTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_files_table_columns = require("./use_files_table_columns");
var _file_preview = require("./file_preview");
var _add_file = require("./add_file");
var _use_file_preview = require("./use_file_preview");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyFilesTable = ({
  caseId
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  title: /*#__PURE__*/_react.default.createElement("h3", null, i18n.NO_FILES),
  "data-test-subj": "cases-files-table-empty",
  titleSize: "xs",
  actions: /*#__PURE__*/_react.default.createElement(_add_file.AddFile, {
    caseId: caseId
  })
});
EmptyFilesTable.displayName = 'EmptyFilesTable';
const FilesTable = ({
  caseId,
  items,
  pagination,
  onChange,
  isLoading
}) => {
  const {
    isPreviewVisible,
    showPreview,
    closePreview
  } = (0, _use_file_preview.useFilePreview)();
  const [selectedFile, setSelectedFile] = (0, _react.useState)();
  const displayPreview = file => {
    setSelectedFile(file);
    showPreview();
  };
  const filesTableRowProps = (0, _react.useCallback)(file => ({
    'data-test-subj': `cases-files-table-row-${file.id}`
  }), []);
  const columns = (0, _use_files_table_columns.useFilesTableColumns)({
    caseId,
    showPreview: displayPreview
  });
  return isLoading ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": "cases-files-table-loading",
    lines: 10
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, pagination.totalItemCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    "data-test-subj": "cases-files-table-results-count"
  }, i18n.SHOWING_FILES(items.length))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableCaption: i18n.FILES_TABLE,
    items: items,
    rowHeader: "name",
    columns: columns,
    pagination: pagination,
    onChange: onChange,
    "data-test-subj": "cases-files-table",
    noItemsMessage: /*#__PURE__*/_react.default.createElement(EmptyFilesTable, {
      caseId: caseId
    }),
    rowProps: filesTableRowProps
  }), isPreviewVisible && selectedFile !== undefined && /*#__PURE__*/_react.default.createElement(_file_preview.FilePreview, {
    closePreview: closePreview,
    selectedFile: selectedFile
  }));
};
exports.FilesTable = FilesTable;
FilesTable.displayName = 'FilesTable';