"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArgLabel = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This is what is being generated by render() from the Arg class. It is called in FunctionForm

const ArgLabel = props => {
  const {
    argId,
    className,
    label,
    help,
    expandable,
    children,
    simpleArg,
    initialIsOpen
  } = props;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: `canvasArg--header${className && ` ${className}`}`
  }, expandable ? /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: `accordion-${argId}`,
    className: "canvasSidebar__accordion",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: help,
      position: "left",
      className: "canvasArg__tooltip"
    }, /*#__PURE__*/_react.default.createElement("span", null, label)),
    extraAction: simpleArg,
    initialIsOpen: initialIsOpen
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasSidebar__accordionContent"
  }, children)) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: help
    }, /*#__PURE__*/_react.default.createElement("span", null, label, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "info",
      color: "subdued"
    }))),
    id: argId
  }, simpleArg || children));
};
exports.ArgLabel = ArgLabel;
ArgLabel.propTypes = {
  argId: _propTypes.default.string,
  label: _propTypes.default.string,
  help: _propTypes.default.string,
  expandable: _propTypes.default.bool,
  initialIsOpen: _propTypes.default.bool,
  simpleArg: _propTypes.default.object,
  children: _propTypes.default.oneOfType([_propTypes.default.node, _propTypes.default.element]).isRequired,
  className: _propTypes.default.string
};