"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HttpInfoSummaryItem = HttpInfoSummaryItem;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _style = require("../../../../utils/style");
var _http_status_badge = require("../http_status_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const urlStyles = (0, _react2.css)`
  display: inline-block;
  vertical-align: bottom;
  max-width: ${_style.unit * 24}px;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
`;
function HttpInfoSummaryItem({
  status,
  method,
  url
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!url) {
    return null;
  }
  const methodLabel = _i18n.i18n.translate('xpack.apm.transactionDetails.requestMethodLabel', {
    defaultMessage: 'Request method'
  });
  return /*#__PURE__*/_react.default.createElement("span", {
    css: (0, _react2.css)`
        whitespace: nowrap;
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    title: undefined,
    css: {
      marginRight: `${euiTheme.size.xs}`
    }
  }, method && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: methodLabel
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "apmHttpInfoRequestMethod"
  }, method.toUpperCase())), ' ', url && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: url
  }, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "apmHttpInfoUrl",
    css: urlStyles
  }, url))), status && /*#__PURE__*/_react.default.createElement(_http_status_badge.HttpStatusBadge, {
    status: status
  }));
}