"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccordionWaterfall = AccordionWaterfall;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _polished = require("polished");
var _react = _interopRequireWildcard(require("react"));
var _reactVirtualized = require("react-virtualized");
var _reactWindow = require("react-window");
var _formatters = require("../../../../../../../common/utils/formatters");
var _use_theme = require("../../../../../../hooks/use_theme");
var _waterfall_item = require("./waterfall_item");
var _waterfall_context = require("./context/waterfall_context");
var _use_waterfall = require("./context/use_waterfall");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ACCORDION_HEIGHT = 48;
const StyledAccordion = (0, _common.euiStyled)(_eui.EuiAccordion).withConfig({
  shouldForwardProp: prop => !['marginLeftLevel', 'hasError'].includes(prop)
})`

  border-top: 1px solid ${({
  theme
}) => theme.eui.euiColorLightShade};

  ${props => {
  const borderLeft = props.hasError ? `2px solid ${props.theme.eui.euiColorDanger};` : `1px solid ${props.theme.eui.euiColorLightShade};`;
  return `.button_${props.id} {
      width: 100%;
      height: ${ACCORDION_HEIGHT}px;
      margin-left: ${props.marginLeftLevel}px;
      border-left: ${borderLeft}
      &:hover {
        background-color: ${props.theme.eui.euiColorLightestShade};
      }
    }`;
}}

  .accordion__buttonContent {
    width: 100%;
    height: 100%;
  }
`;
function AccordionWaterfall({
  maxLevelOpen,
  showCriticalPath,
  waterfall,
  isOpen,
  isEmbeddable = false,
  scrollElement,
  ...props
}) {
  return /*#__PURE__*/_react.default.createElement(_waterfall_context.WaterfallContextProvider, {
    maxLevelOpen: maxLevelOpen,
    showCriticalPath: showCriticalPath,
    waterfall: waterfall,
    isOpen: isOpen,
    isEmbeddable: isEmbeddable
  }, /*#__PURE__*/_react.default.createElement(Waterfall, (0, _extends2.default)({}, props, {
    scrollElement: scrollElement
  })));
}
function Waterfall(props) {
  const listRef = (0, _react.useRef)(null);
  const rowSizeMapRef = (0, _react.useRef)(new Map());
  const {
    traceList
  } = (0, _use_waterfall.useWaterfallContext)();
  const visibleTraceList = props.displayLimit ? traceList.slice(0, props.displayLimit) : traceList;
  const onRowLoad = (index, size) => {
    rowSizeMapRef.current.set(index, size);
  };
  const getRowSize = index => {
    // adds 1px for the border top
    return rowSizeMapRef.current.get(index) || ACCORDION_HEIGHT + 1;
  };
  const onScroll = ({
    scrollTop
  }) => {
    var _listRef$current;
    (_listRef$current = listRef.current) === null || _listRef$current === void 0 ? void 0 : _listRef$current.scrollTo(scrollTop);
  };
  return /*#__PURE__*/_react.default.createElement(_reactVirtualized.WindowScroller, {
    onScroll: onScroll,
    scrollElement: props.scrollElement
  }, ({
    registerChild
  }) => /*#__PURE__*/_react.default.createElement(_reactVirtualized.AutoSizer, {
    disableHeight: true
  }, ({
    width
  }) =>
  /*#__PURE__*/
  // @ts-expect-error @types/react@18 Type 'HTMLDivElement' is not assignable to type 'ReactNode'
  _react.default.createElement("div", {
    "data-test-subj": "waterfall",
    ref: registerChild
  }, /*#__PURE__*/_react.default.createElement(_reactWindow.VariableSizeList, {
    ref: listRef,
    style: {
      height: '100%'
    },
    itemCount: visibleTraceList.length,
    itemSize: getRowSize,
    height: window.innerHeight,
    width: width,
    itemData: {
      ...props,
      traceList: visibleTraceList,
      onLoad: onRowLoad
    }
  }, VirtualRow))));
}
const VirtualRow = /*#__PURE__*/_react.default.memo(({
  index,
  style,
  data
}) => {
  const {
    onLoad,
    traceList,
    ...props
  } = data;
  const ref = _react.default.useRef(null);
  (0, _react.useEffect)(() => {
    var _ref$current$getBound, _ref$current;
    onLoad(index, (_ref$current$getBound = (_ref$current = ref.current) === null || _ref$current === void 0 ? void 0 : _ref$current.getBoundingClientRect().height) !== null && _ref$current$getBound !== void 0 ? _ref$current$getBound : ACCORDION_HEIGHT);
  }, [index, onLoad]);
  return /*#__PURE__*/_react.default.createElement("div", {
    style: style,
    ref: ref
  }, /*#__PURE__*/_react.default.createElement(WaterfallNode, (0, _extends2.default)({}, props, {
    node: traceList[index]
  })));
}, _reactWindow.areEqual);
const WaterfallNode = /*#__PURE__*/_react.default.memo(props => {
  var _criticalPathSegments, _node$item$doc$event;
  const theme = (0, _use_theme.useTheme)();
  const {
    duration,
    waterfallItemId,
    onClickWaterfallItem,
    getRelatedErrorsHref,
    timelineMargins,
    node
  } = props;
  const {
    criticalPathSegmentsById,
    getErrorCount,
    updateTreeNode,
    showCriticalPath,
    isEmbeddable
  } = (0, _use_waterfall.useWaterfallContext)();
  const displayedColor = showCriticalPath ? (0, _polished.transparentize)(0.5, node.item.color) : node.item.color;
  const marginLeftLevel = 8 * node.level;
  const hasToggle = !!node.childrenToLoad;
  const errorCount = getErrorCount(node.item.id);
  const segments = (_criticalPathSegments = criticalPathSegmentsById[node.item.id]) === null || _criticalPathSegments === void 0 ? void 0 : _criticalPathSegments.filter(segment => segment.self).map(segment => ({
    id: segment.item.id,
    color: theme.eui.euiColorAccent,
    left: (segment.offset - node.item.offset - node.item.skew) / node.item.duration,
    width: segment.duration / node.item.duration
  }));
  const toggleAccordion = () => {
    updateTreeNode({
      ...node,
      expanded: !node.expanded
    });
  };
  const onWaterfallItemClick = onClickWaterfallItem ? flyoutDetailTab => {
    onClickWaterfallItem(node.item, flyoutDetailTab);
  } : undefined;
  return /*#__PURE__*/_react.default.createElement(StyledAccordion, {
    "data-test-subj": "accordionWaterfall",
    style: {
      position: 'relative'
    },
    buttonClassName: `button_${node.item.id}`,
    id: node.item.id,
    hasError: ((_node$item$doc$event = node.item.doc.event) === null || _node$item$doc$event === void 0 ? void 0 : _node$item$doc$event.outcome) === 'failure',
    marginLeftLevel: marginLeftLevel,
    buttonContentClassName: "accordion__buttonContent",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(ToggleAccordionButton, {
      show: hasToggle,
      isOpen: node.expanded,
      childrenCount: node.childrenToLoad,
      onClick: toggleAccordion
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_waterfall_item.WaterfallItem, {
      key: node.item.id,
      timelineMargins: timelineMargins,
      color: displayedColor,
      item: node.item,
      hasToggle: hasToggle,
      totalDuration: duration,
      isSelected: node.item.id === waterfallItemId,
      errorCount: errorCount,
      marginLeftLevel: marginLeftLevel,
      onClick: onWaterfallItemClick,
      segments: segments,
      isEmbeddable: isEmbeddable,
      getRelatedErrorsHref: getRelatedErrorsHref
    }))),
    arrowDisplay: "none",
    initialIsOpen: true,
    forceState: node.expanded ? 'open' : 'closed',
    onToggle: toggleAccordion
  });
});
function ToggleAccordionButton({
  show,
  isOpen,
  childrenCount,
  onClick
}) {
  if (!show) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: ACCORDION_HEIGHT,
      display: 'flex'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    justifyContent: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    onClick: e => {
      e.stopPropagation();
      onClick();
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: isOpen ? 'arrowDown' : 'arrowRight'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      position: 'relative'
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      position: 'absolute',
      top: '50%',
      transform: 'translate(0, -50%)'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: childrenCount,
    delay: "long"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, (0, _formatters.asBigNumber)(childrenCount)))))));
}