"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExternalsListContents = ExternalsListContents;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _apm = require("../../../../../common/es_fields/apm");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExternalResourcesList = _common.euiStyled.section`
  max-height: 360px;
  overflow: auto;
`;
function ExternalsListContents({
  elementData
}) {
  const nodeData = elementData;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(ExternalResourcesList, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, null, nodeData.groupedConnections.map(resource => {
    const title = resource.label || resource[_apm.SPAN_DESTINATION_SERVICE_RESOURCE];
    const desc = `${resource[_apm.SPAN_TYPE]} (${resource[_apm.SPAN_SUBTYPE]})`;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: resource.id
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      className: "eui-textTruncate",
      title: title
    }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      className: "eui-textTruncate",
      title: desc
    }, desc));
  }))));
}