"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.edotSDKSettings = void 0;
var _i18n = require("@kbn/i18n");
var _logging_level_rt = require("../runtime_types/logging_level_rt");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const edotSDKSettings = exports.edotSDKSettings = [{
  key: 'deactivate_instrumentations',
  type: 'text',
  defaultValue: '',
  label: _i18n.i18n.translate('xpack.apm.agentConfig.deactivate_instrumentations.label', {
    defaultMessage: 'Deactivate instrumentations'
  }),
  description: _i18n.i18n.translate('xpack.apm.agentConfig.edot.deactivate_instrumentations.description', {
    defaultMessage: 'Comma-separated list of modules to disable instrumentation for.\n' + 'When instrumentation is disabled for a module, no spans will be collected for that module.\n' + '\n' + 'The up-to-date list of modules for which instrumentation can be disabled is language specific ' + 'and can be found under the following links: ' + '[opentelemetry/java/elastic](https://ela.st/otel-agent-instructions)'
  }),
  includeAgents: ['opentelemetry/java/elastic']
}, {
  key: 'deactivate_all_instrumentations',
  type: 'boolean',
  defaultValue: 'false',
  label: _i18n.i18n.translate('xpack.apm.agentConfig.deactivate_all_instrumentations.label', {
    defaultMessage: 'Deactivate all instrumentations'
  }),
  description: _i18n.i18n.translate('xpack.apm.agentConfig.edot.deactivate_all_instrumentations.description', {
    defaultMessage: 'No spans will be collected for any instrumentation modules.\n' + '\n'
  }),
  includeAgents: ['opentelemetry/java/elastic']
}, {
  key: 'logging_level',
  validation: _logging_level_rt.loggingLevelRt,
  type: 'select',
  defaultValue: 'info',
  label: _i18n.i18n.translate('xpack.apm.agentConfig.loggingLevel.label', {
    defaultMessage: 'Logging level'
  }),
  description: _i18n.i18n.translate('xpack.apm.agentConfig.loggingLevel.description', {
    defaultMessage: 'Sets the logging level for the agent'
  }),
  options: [{
    text: 'trace',
    value: 'trace'
  }, {
    text: 'debug',
    value: 'debug'
  }, {
    text: 'info',
    value: 'info'
  }, {
    text: 'warn',
    value: 'warn'
  }, {
    text: 'error',
    value: 'error'
  }, {
    text: 'fatal',
    value: 'fatal'
  }, {
    text: 'off',
    value: 'off'
  }],
  includeAgents: ['opentelemetry/java/elastic']
}, {
  key: 'send_traces',
  type: 'boolean',
  defaultValue: 'true',
  label: _i18n.i18n.translate('xpack.apm.agentConfig.send_traces.label', {
    defaultMessage: 'Send traces'
  }),
  description: _i18n.i18n.translate('xpack.apm.agentConfig.edot.send_traces.description', {
    defaultMessage: 'Set the traces exporter to send or discard traces. When set to false, all traces will be discarded so there will be no traces sent to the collector\n' + '\n'
  }),
  includeAgents: ['opentelemetry/java/elastic']
}, {
  key: 'send_metrics',
  type: 'boolean',
  defaultValue: 'true',
  label: _i18n.i18n.translate('xpack.apm.agentConfig.send_metrics.label', {
    defaultMessage: 'Send metrics'
  }),
  description: _i18n.i18n.translate('xpack.apm.agentConfig.edot.send_metrics.description', {
    defaultMessage: 'Set the metrics exporter to send or discard metrics. When set to false, all metrics will be discarded so there will be no metrics sent to the collector\n' + '\n'
  }),
  includeAgents: ['opentelemetry/java/elastic']
}, {
  key: 'send_logs',
  type: 'boolean',
  defaultValue: 'true',
  label: _i18n.i18n.translate('xpack.apm.agentConfig.send_logs.label', {
    defaultMessage: 'Send logs'
  }),
  description: _i18n.i18n.translate('xpack.apm.agentConfig.edot.send_logs.description', {
    defaultMessage: 'Set the logs exporter to send or discard logs. When set to false, all logs (that are normally sent by the agent) will be discarded so there will be no logs sent to the collector\n' + '\n'
  }),
  includeAgents: ['opentelemetry/java/elastic']
}];