"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _responsive_context = require("./mobile/responsive_context");
var _table = require("./table.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "compressed", "tableLayout", "responsiveBreakpoint"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiTable = exports.EuiTable = function EuiTable(_ref) {
  var children = _ref.children,
    className = _ref.className,
    compressed = _ref.compressed,
    _ref$tableLayout = _ref.tableLayout,
    tableLayout = _ref$tableLayout === void 0 ? 'fixed' : _ref$tableLayout,
    responsiveBreakpoint = _ref.responsiveBreakpoint,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isResponsive = (0, _responsive_context.useIsEuiTableResponsive)(responsiveBreakpoint);
  var classes = (0, _classnames.default)('euiTable', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_table.euiTableStyles);
  var cssStyles = [styles.euiTable, styles.layout[tableLayout], (!compressed || isResponsive) && styles.uncompressed, compressed && !isResponsive && styles.compressed, isResponsive ? styles.mobile : styles.desktop];
  return (0, _react2.jsx)("table", _extends({
    tabIndex: -1,
    css: cssStyles,
    className: classes
  }, rest), (0, _react2.jsx)(_responsive_context.EuiTableIsResponsiveContext.Provider, {
    value: isResponsive
  }, children));
};
EuiTable.propTypes = {
  compressed: _propTypes.default.bool,
  /**
     * Named breakpoint. Below this size, the table will collapse
     * into responsive cards.
     *
     * Pass `false` to never collapse to a mobile view, or inversely,
     * `true` to always render mobile-friendly cards.
     *
     * @default m
     */
  responsiveBreakpoint: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.bool.isRequired]),
  /**
     * Sets the table-layout CSS property
     */
  tableLayout: _propTypes.default.oneOf(["fixed", "auto"]),
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};