"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assertsSchema = assertsSchema;
exports.createAsSchemaOrThrow = createAsSchemaOrThrow;
exports.createIsNarrowSchema = createIsNarrowSchema;
exports.isSchema = isSchema;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createIsNarrowSchema(_base, narrow) {
  return value => {
    return isSchema(narrow, value);
  };
}
function createAsSchemaOrThrow(_base, narrow) {
  return value => {
    narrow.parse(value);
    return value;
  };
}
function isSchema(schema, value) {
  return schema.safeParse(value).success;
}
function assertsSchema(schema, subject) {
  schema.parse(subject);
}