"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInheritedFieldsFromAncestors = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInheritedFieldsFromAncestors = ancestors => {
  return ancestors.reduce((acc, def) => {
    Object.entries(def.ingest.wired.fields).forEach(([key, fieldDef]) => {
      acc[key] = {
        ...fieldDef,
        from: def.name
      };
    });
    return acc;
  }, {});
};
exports.getInheritedFieldsFromAncestors = getInheritedFieldsFromAncestors;