"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessorConditionEditor = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _condition_editor = require("../../condition_editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProcessorConditionEditor = () => {
  const {
    field
  } = (0, _reactHookForm.useController)({
    name: 'if'
  });
  if (field.value === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_condition_editor.ConditionEditor, {
    condition: field.value,
    onConditionChange: field.onChange
  });
};
exports.ProcessorConditionEditor = ProcessorConditionEditor;