"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDataSourcesContextMenu = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactHooks = require("@kbn/react-hooks");
var _translations = require("./translations");
var _utils = require("../state_management/stream_enrichment_state_machine/utils");
var _stream_enrichment_state_machine = require("../state_management/stream_enrichment_state_machine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddDataSourcesContextMenu = () => {
  const {
    addDataSource
  } = (0, _stream_enrichment_state_machine.useStreamEnrichmentEvents)();
  const [isOpen, {
    toggle: toggleMenu,
    off: closeMenu
  }] = (0, _reactHooks.useBoolean)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "data-sources-menu",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: toggleMenu
    }, _translations.DATA_SOURCES_I18N.contextMenu.addDataSource),
    isOpen: isOpen,
    closePopover: closeMenu,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: "data-source-options",
    panels: [{
      id: 'data-source-options',
      items: [{
        name: _translations.DATA_SOURCES_I18N.contextMenu.addKqlDataSource,
        icon: 'search',
        onClick: () => {
          addDataSource(_utils.defaultKqlSamplesDataSource);
          closeMenu();
        }
      }, {
        name: _translations.DATA_SOURCES_I18N.contextMenu.addCustomSamples,
        icon: 'visText',
        onClick: () => {
          addDataSource(_utils.defaultCustomSamplesDataSource);
          closeMenu();
        }
      }]
    }]
  }));
};
exports.AddDataSourcesContextMenu = AddDataSourcesContextMenu;