"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEmailConfig = useEmailConfig;
var _lodash = require("lodash");
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _common = require("../../../common");
var _api = require("./api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConfig = (service, config) => {
  if (service) {
    if (service === _common.AdditionalEmailServices.EXCHANGE) {
      return;
    }
    return {
      host: config !== null && config !== void 0 && config.host ? config.host : '',
      port: config !== null && config !== void 0 && config.port ? config.port : 0,
      secure: null != (config === null || config === void 0 ? void 0 : config.secure) ? config.secure : false
    };
  }
};
function useEmailConfig({
  http,
  toasts
}) {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const abortCtrlRef = (0, _react.useRef)(new AbortController());
  const isMounted = (0, _react.useRef)(false);
  const getEmailServiceConfig = (0, _react.useCallback)(async service => {
    if (service == null || (0, _lodash.isEmpty)(service)) {
      return;
    }
    setIsLoading(true);
    isMounted.current = true;
    abortCtrlRef.current.abort();
    abortCtrlRef.current = new AbortController();
    try {
      const serviceConfig = await (0, _api.getServiceConfig)({
        http,
        service
      });
      if (isMounted.current) {
        setIsLoading(false);
      }
      return getConfig(service, serviceConfig);
    } catch (error) {
      if (isMounted.current) {
        setIsLoading(false);
        if (error.name !== 'AbortError') {
          var _error$body$message, _error$body;
          toasts.addDanger((_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : _i18n.i18n.translate('xpack.stackConnectors.components.email.updateErrorNotificationText', {
            defaultMessage: 'Cannot get service configuration'
          }));
        }
      }
    }
  }, [http, toasts]);
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;
      abortCtrlRef.current.abort();
    };
  }, []);
  return {
    isLoading,
    getEmailServiceConfig
  };
}