"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestQueryRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_test_query = require("./use_test_query");
var _test_query_row_table = require("./test_query_row_table");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TestQueryRow = ({
  fetch,
  copyQuery,
  hasValidationErrors,
  showTable
}) => {
  const {
    onTestQuery,
    testQueryResult,
    testQueryError,
    testQueryWarning,
    testQueryLoading,
    testQueryPreview
  } = (0, _use_test_query.useTestQuery)(fetch);
  const [copiedMessage, setCopiedMessage] = (0, _react.useState)(null);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "testQuery",
    color: "primary",
    iconSide: "left",
    iconType: "playFilled",
    onClick: () => {
      onTestQuery();
    },
    disabled: hasValidationErrors,
    isLoading: testQueryLoading,
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackAlerts.esQuery.ui.testQuery",
    defaultMessage: "Test query"
  }))), copyQuery && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: copiedMessage,
    onMouseOut: () => {
      setCopiedMessage(null);
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "copyQuery",
    color: "primary",
    iconSide: "left",
    iconType: "copyClipboard",
    onClick: () => {
      const copied = (0, _eui.copyToClipboard)(copyQuery());
      if (copied) {
        setCopiedMessage(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.stackAlerts.esQuery.ui.queryCopiedToClipboard",
          defaultMessage: "Copied"
        }));
      }
    },
    disabled: hasValidationErrors,
    isLoading: testQueryLoading,
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackAlerts.esQuery.ui.copyQuery",
    defaultMessage: "Copy query"
  })))))), testQueryLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackAlerts.esQuery.ui.testQueryIsExecuted",
    defaultMessage: "Query is executed."
  })))), testQueryResult && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "testQuerySuccess",
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, testQueryResult))), testQueryError && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "testQueryError",
    color: "danger",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, testQueryError))), testQueryWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    size: "s",
    title: testQueryWarning,
    iconType: "warning"
  })), showTable && testQueryPreview && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_test_query_row_table.TestQueryRowTable, {
    preview: testQueryPreview
  })));
};
exports.TestQueryRow = TestQueryRow;