"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoSpacesAvailable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoSpacesAvailable = props => {
  const {
    capabilities,
    getUrlForApp
  } = props.application;
  const canCreateNewSpaces = capabilities.spaces.manage;
  if (!canCreateNewSpaces) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.shareToSpace.noAvailableSpaces.canCreateNewSpace.text",
    defaultMessage: "You can {createANewSpaceLink} for sharing your objects.",
    values: {
      createANewSpaceLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "sts-new-space-link",
        href: getUrlForApp('management', {
          path: 'kibana/spaces/create'
        })
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.spaces.shareToSpace.noAvailableSpaces.canCreateNewSpace.linkText",
        defaultMessage: "create a new space"
      }))
    }
  })));
};
exports.NoSpacesAvailable = NoSpacesAvailable;