"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGroupBy = void 0;
var _sloSchema = require("@kbn/slo-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGroupBy = slo => {
  const groups = [slo.groupBy].flat().filter(group => !!group);
  const groupings = !groups.includes(_sloSchema.ALL_VALUE) && groups.length ? groups.reduce((acc, field) => {
    return {
      ...acc,
      [`slo.groupings.${field}`]: {
        terms: {
          field: `slo.groupings.${field}`
        }
      }
    };
  }, {}) : {};
  return {
    'slo.id': {
      terms: {
        field: 'slo.id'
      }
    },
    'slo.revision': {
      terms: {
        field: 'slo.revision'
      }
    },
    'slo.instanceId': {
      terms: {
        field: 'slo.instanceId'
      }
    },
    ...groupings,
    // optional fields: only specified for APM indicators. Must include missing_bucket:true
    'service.name': {
      terms: {
        field: 'service.name',
        missing_bucket: true
      }
    },
    'service.environment': {
      terms: {
        field: 'service.environment',
        missing_bucket: true
      }
    },
    'transaction.name': {
      terms: {
        field: 'transaction.name',
        missing_bucket: true
      }
    },
    'transaction.type': {
      terms: {
        field: 'transaction.type',
        missing_bucket: true
      }
    },
    // optional fields: only specified for Synthetics indicators. Must include missing_bucket:true
    'observer.geo.name': {
      terms: {
        field: 'observer.geo.name',
        missing_bucket: true
      }
    },
    'observer.name': {
      terms: {
        field: 'observer.name',
        missing_bucket: true
      }
    },
    'monitor.config_id': {
      terms: {
        field: 'monitor.config_id',
        missing_bucket: true
      }
    },
    'monitor.name': {
      terms: {
        field: 'monitor.name',
        missing_bucket: true
      }
    }
  };
};
exports.getGroupBy = getGroupBy;