"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSLORoute = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _services = require("../../services");
var _slo_definition_client = require("../../services/slo_definition_client");
var _create_slo_server_route = require("../create_slo_server_route");
var _assert_platinum_license = require("./utils/assert_platinum_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSLORoute = exports.getSLORoute = (0, _create_slo_server_route.createSloServerRoute)({
  endpoint: 'GET /api/observability/slos/{id} 2023-10-31',
  options: {
    access: 'public'
  },
  security: {
    authz: {
      requiredPrivileges: ['slo_read']
    }
  },
  params: _sloSchema.getSLOParamsSchema,
  handler: async ({
    request,
    logger,
    params,
    plugins,
    getScopedClients
  }) => {
    await (0, _assert_platinum_license.assertPlatinumLicense)(plugins);
    const {
      scopedClusterClient,
      spaceId,
      repository
    } = await getScopedClients({
      request,
      logger
    });
    const burnRatesClient = new _services.DefaultBurnRatesClient(scopedClusterClient.asCurrentUser);
    const summaryClient = new _services.DefaultSummaryClient(scopedClusterClient.asCurrentUser, burnRatesClient);
    const definitionClient = new _slo_definition_client.SloDefinitionClient(repository, scopedClusterClient.asCurrentUser, logger);
    const getSLO = new _services.GetSLO(definitionClient, summaryClient);
    return await getSLO.execute(params.path.id, spaceId, params.query);
  }
});