"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUMMARY_INDEX_TEMPLATE = void 0;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SUMMARY_INDEX_TEMPLATE = exports.SUMMARY_INDEX_TEMPLATE = {
  name: _constants.SUMMARY_INDEX_TEMPLATE_NAME,
  index_patterns: [_constants.SUMMARY_INDEX_TEMPLATE_PATTERN],
  composed_of: [_constants.SUMMARY_COMPONENT_TEMPLATE_MAPPINGS_NAME, _constants.SUMMARY_COMPONENT_TEMPLATE_SETTINGS_NAME],
  priority: 500,
  _meta: {
    description: 'SLO summary index template',
    version: _constants.SLO_RESOURCES_VERSION,
    managed: true,
    managed_by: 'observability'
  }
};