"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloListEmpty = SloListEmpty;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_url_search_state = require("../hooks/use_url_search_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloListEmpty() {
  const {
    onStateChange
  } = (0, _use_url_search_state.useUrlSearchState)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.slo.list.emptyTitle', {
      defaultMessage: 'No results'
    }),
    color: "warning",
    iconType: "warning"
  }, _i18n.i18n.translate('xpack.slo.list.emptyMessage', {
    defaultMessage: 'There are no results for your criteria.'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "sloSloListEmptyLinkButtonButton",
    onClick: () => {
      onStateChange({
        kqlQuery: '',
        filters: [],
        tagsFilter: undefined,
        statusFilter: undefined
      });
    },
    color: "primary"
  }, _i18n.i18n.translate('xpack.slo.sloListEmpty.clearFiltersButtonLabel', {
    defaultMessage: 'Clear filters'
  })));
}