"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchActiveAlerts = void 0;
var _active_alerts = require("../active_alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchActiveAlerts = ({
  sloIdsAndInstanceIds = []
}) => {
  const data = sloIdsAndInstanceIds.reduce((acc, item, index) => ({
    ...acc,
    ...(index % 2 === 0 && {
      [item.join('|')]: 2
    })
  }), {});
  return {
    isLoading: false,
    isSuccess: false,
    isError: false,
    data: new _active_alerts.ActiveAlerts(data)
  };
};
exports.useFetchActiveAlerts = useFetchActiveAlerts;