"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloDeleteConfirmationModal = SloDeleteConfirmationModal;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _sloSchema = require("@kbn/slo-schema");
var _react = _interopRequireWildcard(require("react"));
var _use_delete_slo = require("../../../hooks/use_delete_slo");
var _use_delete_slo_instance = require("../../../hooks/use_delete_slo_instance");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloDeleteConfirmationModal({
  slo,
  onCancel,
  onConfirm
}) {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    mutate: deleteSlo
  } = (0, _use_delete_slo.useDeleteSlo)();
  const {
    mutate: deleteSloInstance
  } = (0, _use_delete_slo_instance.useDeleteSloInstance)();
  const {
    name,
    groupBy
  } = slo;
  const instanceId = 'instanceId' in slo && slo.instanceId !== _sloSchema.ALL_VALUE ? slo.instanceId : undefined;
  const hasGroupBy = [groupBy].flat().some(group => group !== _sloSchema.ALL_VALUE);
  const [isDeleteRollupDataChecked, toggleDeleteRollupDataSwitch] = (0, _react.useState)(false);
  const onDeleteRollupDataSwitchChange = () => toggleDeleteRollupDataSwitch(!isDeleteRollupDataChecked);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-labelledby": modalTitleId,
    onClose: onCancel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId
  }, hasGroupBy && instanceId ? getInstanceTitleLabel(name, instanceId) : getTitleLabel(name))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, hasGroupBy && instanceId ? /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: {
      marginBottom: '2rem'
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.deleteConfirmationModal.groupByDisclaimerText",
    defaultMessage: "This SLO is an instance of many SLO instances."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "popswitch",
    label: _i18n.i18n.translate('xpack.slo.deleteConfirmationModal.switchDeleteRollupData', {
      defaultMessage: 'Delete rollup data for this instance'
    }),
    checked: isDeleteRollupDataChecked,
    onChange: onDeleteRollupDataSwitchChange
  }))) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.deleteConfirmationModal.descriptionText",
    defaultMessage: "You can't recover this SLO after deleting it."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "observabilitySolutionSloDeleteModalCancelButton",
    onClick: onCancel
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.deleteConfirmationModal.cancelButtonLabel",
    defaultMessage: "Cancel"
  })), hasGroupBy && instanceId && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "observabilitySolutionSloDeleteModalConfirmButton",
    type: "submit",
    color: "danger",
    onClick: () => {
      deleteSloInstance({
        slo: {
          id: slo.id,
          instanceId,
          name: slo.name
        },
        excludeRollup: isDeleteRollupDataChecked === false
      });
      onConfirm();
    },
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.deleteConfirmationModal.deleteInstanceButtonLabel",
    defaultMessage: "Delete this instance only"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "observabilitySolutionSloDeleteModalConfirmButton",
    type: "submit",
    color: "danger",
    onClick: () => {
      deleteSlo({
        id: slo.id,
        name: slo.name
      });
      onConfirm();
    },
    fill: true
  }, hasGroupBy && instanceId ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.deleteConfirmationModal.deleteAllButtonLabel",
    defaultMessage: "Delete SLO and all Instances"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.deleteConfirmationModal.deleteButtonLabel",
    defaultMessage: "Delete"
  }))));
}
function getTitleLabel(name) {
  return _i18n.i18n.translate('xpack.slo.deleteConfirmationModal.title', {
    defaultMessage: 'Delete {name}?',
    values: {
      name
    }
  });
}
function getInstanceTitleLabel(name, instanceId) {
  return _i18n.i18n.translate('xpack.slo.deleteConfirmationModal.instanceTitle', {
    defaultMessage: 'Delete {name} [{instanceId}]?',
    values: {
      name,
      instanceId
    }
  });
}