"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionNamespaceTypeEnum = exports.ExceptionNamespaceType = exports.ExceptionListVersion = exports.ExceptionListTypeEnum = exports.ExceptionListType = exports.ExceptionListTags = exports.ExceptionListSO = exports.ExceptionListOsTypeEnum = exports.ExceptionListOsTypeArray = exports.ExceptionListOsType = exports.ExceptionListName = exports.ExceptionListMeta = exports.ExceptionListItemType = exports.ExceptionListItemTags = exports.ExceptionListItemOsTypeEnum = exports.ExceptionListItemOsTypeArray = exports.ExceptionListItemOsType = exports.ExceptionListItemName = exports.ExceptionListItemMeta = exports.ExceptionListItemId = exports.ExceptionListItemHumanId = exports.ExceptionListItemDescription = exports.ExceptionListItemCommentArray = exports.ExceptionListItemComment = exports.ExceptionListItem = exports.ExceptionListId = exports.ExceptionListHumanId = exports.ExceptionListDescription = exports.ExceptionList = void 0;
var _zod = require("@kbn/zod");
var _primitives = require("@kbn/openapi-common/schemas/primitives.gen");
var _exception_list_item_entry = require("./exception_list_item_entry.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Exception List Attributes
 *   version: not applicable
 */

const ExceptionListId = exports.ExceptionListId = _primitives.NonEmptyString;

/**
 * The exception list's human readable string identifier, `endpoint_list`.
 */

const ExceptionListHumanId = exports.ExceptionListHumanId = _primitives.NonEmptyString;
const ExceptionListType = exports.ExceptionListType = _zod.z.enum(['detection', 'rule_default', 'endpoint', 'endpoint_trusted_apps', 'endpoint_events', 'endpoint_host_isolation_exceptions', 'endpoint_blocklists']);
const ExceptionListTypeEnum = exports.ExceptionListTypeEnum = ExceptionListType.enum;
const ExceptionListName = exports.ExceptionListName = _zod.z.string();
const ExceptionListDescription = exports.ExceptionListDescription = _zod.z.string();
const ExceptionListMeta = exports.ExceptionListMeta = _zod.z.object({}).catchall(_zod.z.unknown());

/**
  * Determines whether the exception container is available in all Kibana spaces or just the space
in which it is created, where:

- `single`: Only available in the Kibana space in which it is created.
- `agnostic`: Available in all Kibana spaces.

  */

const ExceptionNamespaceType = exports.ExceptionNamespaceType = _zod.z.enum(['agnostic', 'single']);
const ExceptionNamespaceTypeEnum = exports.ExceptionNamespaceTypeEnum = ExceptionNamespaceType.enum;
const ExceptionListTags = exports.ExceptionListTags = _zod.z.array(_zod.z.string());
const ExceptionListOsType = exports.ExceptionListOsType = _zod.z.enum(['linux', 'macos', 'windows']);
const ExceptionListOsTypeEnum = exports.ExceptionListOsTypeEnum = ExceptionListOsType.enum;
const ExceptionListOsTypeArray = exports.ExceptionListOsTypeArray = _zod.z.array(ExceptionListOsType);
const ExceptionListVersion = exports.ExceptionListVersion = _zod.z.number().int().min(1);
const ExceptionList = exports.ExceptionList = _zod.z.object({
  id: ExceptionListId,
  list_id: ExceptionListHumanId,
  type: ExceptionListType,
  name: ExceptionListName,
  description: ExceptionListDescription,
  immutable: _zod.z.boolean(),
  namespace_type: ExceptionNamespaceType,
  os_types: ExceptionListOsTypeArray.optional(),
  tags: ExceptionListTags.optional(),
  meta: ExceptionListMeta.optional(),
  version: ExceptionListVersion,
  _version: _zod.z.string().optional(),
  tie_breaker_id: _zod.z.string(),
  created_at: _zod.z.string().datetime(),
  created_by: _zod.z.string(),
  updated_at: _zod.z.string().datetime(),
  updated_by: _zod.z.string()
});
const ExceptionListItemId = exports.ExceptionListItemId = _primitives.NonEmptyString;
const ExceptionListItemHumanId = exports.ExceptionListItemHumanId = _primitives.NonEmptyString;
const ExceptionListItemType = exports.ExceptionListItemType = _zod.z.literal('simple');
const ExceptionListItemName = exports.ExceptionListItemName = _primitives.NonEmptyString;
const ExceptionListItemDescription = exports.ExceptionListItemDescription = _zod.z.string();
const ExceptionListItemMeta = exports.ExceptionListItemMeta = _zod.z.object({}).catchall(_zod.z.unknown());
const ExceptionListItemTags = exports.ExceptionListItemTags = _zod.z.array(_primitives.NonEmptyString);
const ExceptionListItemOsType = exports.ExceptionListItemOsType = _zod.z.enum(['linux', 'macos', 'windows']);
const ExceptionListItemOsTypeEnum = exports.ExceptionListItemOsTypeEnum = ExceptionListItemOsType.enum;
const ExceptionListItemOsTypeArray = exports.ExceptionListItemOsTypeArray = _zod.z.array(ExceptionListOsType);
const ExceptionListItemComment = exports.ExceptionListItemComment = _zod.z.object({
  id: _primitives.NonEmptyString,
  comment: _primitives.NonEmptyString,
  created_at: _zod.z.string().datetime(),
  created_by: _primitives.NonEmptyString,
  updated_at: _zod.z.string().datetime().optional(),
  updated_by: _primitives.NonEmptyString.optional()
});
const ExceptionListItemCommentArray = exports.ExceptionListItemCommentArray = _zod.z.array(ExceptionListItemComment);
const ExceptionListItem = exports.ExceptionListItem = _zod.z.object({
  id: ExceptionListItemId,
  item_id: ExceptionListItemHumanId,
  list_id: ExceptionListHumanId,
  type: ExceptionListItemType,
  name: ExceptionListItemName,
  description: ExceptionListItemDescription,
  entries: _exception_list_item_entry.ExceptionListItemEntryArray,
  namespace_type: ExceptionNamespaceType,
  os_types: ExceptionListItemOsTypeArray.optional(),
  tags: ExceptionListItemTags.optional(),
  meta: ExceptionListItemMeta.optional(),
  expire_time: _zod.z.string().datetime().optional(),
  comments: ExceptionListItemCommentArray,
  _version: _zod.z.string().optional(),
  tie_breaker_id: _zod.z.string(),
  created_at: _zod.z.string().datetime(),
  created_by: _zod.z.string(),
  updated_at: _zod.z.string().datetime(),
  updated_by: _zod.z.string()
});
const ExceptionListSO = exports.ExceptionListSO = _zod.z.object({
  item_id: ExceptionListItemHumanId.optional(),
  list_id: ExceptionListHumanId,
  list_type: _zod.z.enum(['item', 'list']),
  immutable: _zod.z.boolean().optional(),
  type: ExceptionListItemType,
  name: ExceptionListItemName,
  description: ExceptionListItemDescription,
  entries: _exception_list_item_entry.ExceptionListItemEntryArray.optional(),
  os_types: ExceptionListItemOsTypeArray.optional(),
  tags: ExceptionListItemTags.optional(),
  meta: ExceptionListItemMeta.optional(),
  expire_time: _zod.z.string().datetime().optional(),
  comments: ExceptionListItemCommentArray.optional(),
  version: _primitives.NonEmptyString.optional(),
  tie_breaker_id: _zod.z.string(),
  created_at: _zod.z.string().datetime(),
  created_by: _zod.z.string(),
  updated_by: _zod.z.string()
});