"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.conditions = void 0;
var _constants = require("../../../../../common/siem_migrations/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const conditions = exports.conditions = {
  isFullyTranslated() {
    return {
      term: {
        translation_result: _constants.RuleTranslationResult.FULL
      }
    };
  },
  isNotFullyTranslated() {
    return {
      bool: {
        must_not: conditions.isFullyTranslated()
      }
    };
  },
  isPartiallyTranslated() {
    return {
      term: {
        translation_result: _constants.RuleTranslationResult.PARTIAL
      }
    };
  },
  isNotPartiallyTranslated() {
    return {
      bool: {
        must_not: conditions.isPartiallyTranslated()
      }
    };
  },
  isUntranslatable() {
    return {
      term: {
        translation_result: _constants.RuleTranslationResult.UNTRANSLATABLE
      }
    };
  },
  isNotUntranslatable() {
    return {
      bool: {
        must_not: conditions.isUntranslatable()
      }
    };
  },
  isInstalled() {
    return {
      exists: {
        field: 'elastic_rule.id'
      }
    };
  },
  isNotInstalled() {
    return {
      bool: {
        must_not: conditions.isInstalled()
      }
    };
  },
  isPrebuilt() {
    return {
      exists: {
        field: 'elastic_rule.prebuilt_rule_id'
      }
    };
  },
  isCustom() {
    return {
      bool: {
        must_not: conditions.isPrebuilt()
      }
    };
  },
  matchTitle(title) {
    return {
      match: {
        'elastic_rule.title': title
      }
    };
  },
  isInstallable() {
    return [conditions.isFullyTranslated(), conditions.isNotInstalled()];
  },
  isNotInstallable() {
    return [conditions.isNotFullyTranslated(), conditions.isInstalled()];
  },
  isFailed() {
    return {
      term: {
        status: _constants.SiemMigrationStatus.FAILED
      }
    };
  },
  isNotFailed() {
    return {
      bool: {
        must_not: conditions.isFailed()
      }
    };
  }
};