"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logEsqlRequest = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const logEsqlRequest = (requestBody, requestQueryParams) => {
  const urlParams = Object.entries(requestQueryParams !== null && requestQueryParams !== void 0 ? requestQueryParams : {}).reduce((acc, [key, value]) => {
    if (value != null) {
      acc.push(`${key}=${value}`);
    }
    return acc;
  }, []).join('&');
  return `POST _query/async${urlParams ? `?${urlParams}` : ''}\n${JSON.stringify(requestBody, null, 2)}`;
};
exports.logEsqlRequest = logEsqlRequest;