"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getScheduleNotificationResponseActionsService = void 0;
var _expand_dotted = require("../../../../common/utils/expand_dotted");
var _rule_response_actions = require("../../../../common/api/detection_engine/model/rule_response_actions");
var _osquery_response_action = require("./osquery_response_action");
var _endpoint_response_action = require("./endpoint_response_action");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getScheduleNotificationResponseActionsService = ({
  osqueryCreateActionService,
  endpointAppContextService
}) => async ({
  signals,
  signalsCount,
  responseActions
}) => {
  if (!signalsCount || !(responseActions !== null && responseActions !== void 0 && responseActions.length)) {
    return;
  }
  // expandDottedObject is needed eg in ESQL rule because it's alerts come without nested agent, host etc data but everything is dotted
  const nestedAlerts = signals.map(signal => (0, _expand_dotted.expandDottedObject)(signal));
  const alerts = nestedAlerts.filter(alert => {
    var _alert$agent;
    return (_alert$agent = alert.agent) === null || _alert$agent === void 0 ? void 0 : _alert$agent.id;
  });
  if (!alerts.length) {
    return;
  }
  return Promise.all(responseActions.map(async responseAction => {
    if (responseAction.actionTypeId === _rule_response_actions.ResponseActionTypesEnum['.osquery'] && osqueryCreateActionService) {
      await (0, _osquery_response_action.osqueryResponseAction)(responseAction, osqueryCreateActionService, {
        alerts
      });
    }
    if (responseAction.actionTypeId === _rule_response_actions.ResponseActionTypesEnum['.endpoint']) {
      // We currently support only automated response actions for Elastic Defend. This will
      // need to be updated once we introduce support for other EDR systems.
      // For an explanation of why this is needed, see this comment here:
      // https://github.com/elastic/kibana/issues/180774#issuecomment-2139526239
      const alertsFromElasticDefend = alerts.filter(alert => alert.agent.type === 'endpoint');
      if (alertsFromElasticDefend.length > 0) {
        await (0, _endpoint_response_action.endpointResponseAction)(responseAction, endpointAppContextService, {
          alerts: alertsFromElasticDefend
        });
      }
    }
  }));
};
exports.getScheduleNotificationResponseActionsService = getScheduleNotificationResponseActionsService;