"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateIsCustomized = calculateIsCustomized;
var _detection_engine = require("../../../../../../../../common/api/detection_engine");
var _calculate_rule_fields_diff = require("../../../../../prebuilt_rules/logic/diff/calculation/calculate_rule_fields_diff");
var _convert_rule_to_diffable = require("../../../../../../../../common/detection_engine/prebuilt_rules/diff/convert_rule_to_diffable");
var _convert_prebuilt_rule_asset_to_rule_response = require("../../converters/convert_prebuilt_rule_asset_to_rule_response");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function calculateIsCustomized({
  baseRule,
  nextRule,
  currentRule
}) {
  if (baseRule) {
    // Base version is available, so we can determine the customization status
    // by comparing the base version with the next version
    return areRulesEqual((0, _convert_prebuilt_rule_asset_to_rule_response.convertPrebuiltRuleAssetToRuleResponse)(baseRule), nextRule) === false;
  }
  // Base version is not available, apply a heuristic to determine the
  // customization status

  if (currentRule == null) {
    // Current rule is not installed and base rule is not available, so we can't
    // determine if the rule is customized. Defaulting to false.
    return false;
  }
  if (currentRule.rule_source.type === 'external' && currentRule.rule_source.is_customized === true) {
    // If the rule was previously customized, there's no way to determine
    // whether the customization remained or was reverted. Keeping it as
    // customized in this case.
    return true;
  }

  // If the rule has not been customized before, its customization status can be
  // determined by comparing the current version with the next version.
  return areRulesEqual(currentRule, nextRule) === false;
}

/**
 * A helper function to determine if two rules are equal
 *
 * @param ruleA
 * @param ruleB
 * @returns true if all rule fields are equal, false otherwise
 */
function areRulesEqual(ruleA, ruleB) {
  const fieldsDiff = (0, _calculate_rule_fields_diff.calculateRuleFieldsDiff)({
    base_version: _detection_engine.MissingVersion,
    current_version: (0, _convert_rule_to_diffable.convertRuleToDiffable)(ruleA),
    target_version: (0, _convert_rule_to_diffable.convertRuleToDiffable)(ruleB)
  });
  return Object.values(fieldsDiff).every(diff => diff.has_update === false);
}