"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMappingsFor818Compatibility = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _securitysolutionRules = require("@kbn/securitysolution-rules");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createMappingsFor818Compatibility = () => ({
  runtime: {
    [_ruleDataUtils.ALERT_RULE_CONSUMER]: {
      type: 'keyword',
      script: {
        source: "emit('siem')"
      }
    },
    [_ruleDataUtils.ALERT_RULE_TYPE_ID]: {
      type: 'keyword',
      script: {
        source: mapRuleTypeToRuleTypeIdScript(_securitysolutionRules.ruleTypeMappings)
      }
    }
  }
});
exports.createMappingsFor818Compatibility = createMappingsFor818Compatibility;
const mapRuleTypeToRuleTypeIdScript = ruleTypeToRuleTypeIdMap => `
  String rule_type = doc['${_ruleDataUtils.ALERT_RULE_TYPE}'].value;
  ${Object.entries(ruleTypeToRuleTypeIdMap).map(([ruleType, ruleTypeId]) => `if (rule_type == '${ruleType}') return emit('${ruleTypeId}');`).join('')}`;