"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCompleteBadgeText = exports.getAgentsData = exports.getActiveIntegrationList = void 0;
var _public = require("@kbn/fleet-plugin/public");
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCompleteBadgeText = installedCount => _i18n.i18n.translate('xpack.securitySolution.onboarding.integrationsCard.badge.completeText', {
  defaultMessage: '{count} {count, plural, one {integration} other {integrations}} added',
  values: {
    count: installedCount
  }
});
exports.getCompleteBadgeText = getCompleteBadgeText;
const getActiveIntegrationList = async (services, availableIntegrationNames) => {
  var _activePackageData$it, _activePackageData$it2;
  const activePackageData = await services.http.get(`${_public.EPM_API_ROUTES.INSTALLED_LIST_PATTERN}`, {
    version: '2023-10-31',
    query: {
      showOnlyActiveDataStreams: true
    }
  }).catch(err => {
    const emptyItems = [];
    services.notifications.toasts.addError(err, {
      title: _i18n.i18n.translate('xpack.securitySolution.onboarding.integrationsCard.checkComplete.fetchIntegrations.errorTitle', {
        defaultMessage: 'Error fetching integrations data'
      })
    });
    return {
      items: emptyItems
    };
  });
  const activePackages = (_activePackageData$it = activePackageData === null || activePackageData === void 0 ? void 0 : (_activePackageData$it2 = activePackageData.items) === null || _activePackageData$it2 === void 0 ? void 0 : _activePackageData$it2.filter(installedPkg => {
    const isInstalled = (installedPkg.status === _public.installationStatuses.Installed || installedPkg.status === _public.installationStatuses.InstallFailed) && installedPkg.dataStreams.length > 0;
    return availableIntegrationNames ? isInstalled && availableIntegrationNames.some(availableIntegration => availableIntegration === installedPkg.name) : isInstalled;
  })) !== null && _activePackageData$it !== void 0 ? _activePackageData$it : [];
  const isComplete = activePackages && activePackages.length > 0;
  return {
    isComplete,
    activePackages
  };
};
exports.getActiveIntegrationList = getActiveIntegrationList;
const getAgentsData = async (services, isComplete) => {
  var _agentsData$rawRespon, _agentsData$rawRespon2;
  const agentsData = await (0, _rxjs.lastValueFrom)(services.data.search.search({
    params: {
      index: _constants.AGENT_INDEX,
      body: {
        size: 1
      }
    }
  })).catch(err => {
    services.notifications.toasts.addError(err, {
      title: _i18n.i18n.translate('xpack.securitySolution.onboarding.integrationsCard.checkComplete.fetchAgents.errorTitle', {
        defaultMessage: 'Error fetching agents data'
      })
    });
    return {
      rawResponse: {
        hits: {
          total: 0
        }
      }
    };
  });
  const agentsDataAvailable = !!(agentsData !== null && agentsData !== void 0 && (_agentsData$rawRespon = agentsData.rawResponse) !== null && _agentsData$rawRespon !== void 0 && (_agentsData$rawRespon2 = _agentsData$rawRespon.hits) !== null && _agentsData$rawRespon2 !== void 0 && _agentsData$rawRespon2.total);
  // If the integration card is complete (has one active integration), we don't need to check for agents data
  const isAgentRequired = !isComplete && !agentsDataAvailable;
  return {
    isAgentRequired,
    agentsData
  };
};
exports.getAgentsData = getAgentsData;