"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetEndpointDetails = void 0;
var _reactQuery = require("@kbn/react-query");
var _resolve_path_variables = require("../../../common/utils/resolve_path_variables");
var _kibana = require("../../../common/lib/kibana");
var _constants = require("../../../../common/endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Get info for a security solution endpoint host using the endpoint id (`agent.id`)
 * @param endpointId
 * @param options
 */
const useGetEndpointDetails = (endpointId, options = {}) => {
  const http = (0, _kibana.useHttp)();
  return (0, _reactQuery.useQuery)({
    queryKey: ['get-endpoint-host-info', endpointId],
    ...options,
    queryFn: () => {
      return http.get((0, _resolve_path_variables.resolvePathVariables)(_constants.HOST_METADATA_GET_ROUTE, {
        id: endpointId.trim() || 'undefined'
      }), {
        version: '2023-10-31'
      });
    }
  });
};
exports.useGetEndpointDetails = useGetEndpointDetails;