"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchExceptions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _policies_selector = require("../policies_selector");
var _user_privileges = require("../../../common/components/user_privileges");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchExceptions = exports.SearchExceptions = /*#__PURE__*/(0, _react.memo)(({
  defaultValue = '',
  onSearch,
  placeholder,
  hasPolicyFilter,
  policyList,
  defaultIncludedPolicies,
  hideRefreshButton = false
}) => {
  const {
    canCreateArtifactsByPolicy
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const [query, setQuery] = (0, _react.useState)(defaultValue);
  const [includedPolicies, setIncludedPolicies] = (0, _react.useState)(defaultIncludedPolicies || '');
  const onChangeSelection = (0, _react.useCallback)(items => {
    const includePoliciesNew = items.filter(item => item.checked === 'on').map(item => item.id).join(',');
    setIncludedPolicies(includePoliciesNew);
    onSearch(query, includePoliciesNew, false);
  }, [onSearch, query]);
  const handleOnChangeSearchField = (0, _react.useCallback)(ev => setQuery(ev.target.value), [setQuery]);
  const handleOnSearch = (0, _react.useCallback)(() => onSearch(query, includedPolicies, true), [onSearch, query, includedPolicies]);
  const handleOnSearchQuery = (0, _react.useCallback)(value => {
    onSearch(value, includedPolicies, false);
  }, [onSearch, includedPolicies]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "searchExceptions",
    direction: "row",
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    defaultValue: defaultValue,
    placeholder: placeholder,
    onChange: handleOnChangeSearchField,
    onSearch: handleOnSearchQuery,
    isClearable: true,
    fullWidth: true,
    "data-test-subj": "searchField"
  })), canCreateArtifactsByPolicy && hasPolicyFilter && policyList ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_policies_selector.PoliciesSelector, {
    policies: policyList,
    defaultIncludedPolicies: defaultIncludedPolicies,
    onChangeSelection: onChangeSelection
  })) : null, !hideRefreshButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "refresh",
    onClick: handleOnSearch,
    "data-test-subj": "searchButton"
  }, _i18n.i18n.translate('xpack.securitySolution.management.search.button', {
    defaultMessage: 'Refresh'
  }))) : null);
});
SearchExceptions.displayName = 'SearchExceptions';