"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNavigateToUserDetails = void 0;
var _expandableFlyout = require("@kbn/expandable-flyout");
var _react = require("react");
var _search_strategy = require("../../../../../common/search_strategy");
var _kibana = require("../../../../common/lib/kibana");
var _telemetry = require("../../../../common/lib/telemetry");
var _user_details_left = require("../../user_details_left");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _constants = require("../../shared/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useNavigateToUserDetails = ({
  userName,
  email,
  scopeId,
  contextID,
  isRiskScoreExist,
  hasMisconfigurationFindings,
  hasNonClosedAlerts,
  isPreviewMode
}) => {
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    openLeftPanel,
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const isNewNavigationEnabled = !(0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newExpandableFlyoutNavigationDisabled');
  const isLinkEnabled = !isPreviewMode || isNewNavigationEnabled && isPreviewMode;
  const openDetailsPanel = (0, _react.useCallback)(path => {
    telemetry.reportEvent(_telemetry.EntityEventTypes.RiskInputsExpandedFlyoutOpened, {
      entity: _search_strategy.EntityType.user
    });
    const left = {
      id: _user_details_left.UserDetailsPanelKey,
      params: {
        isRiskScoreExist,
        scopeId,
        user: {
          name: userName,
          email
        },
        path,
        hasMisconfigurationFindings,
        hasNonClosedAlerts
      }
    };
    const right = {
      id: _constants.UserPanelKey,
      params: {
        contextID,
        userName,
        scopeId
      }
    };

    // When new navigation is enabled, nevigation in preview is enabled and open a new flyout
    if (isNewNavigationEnabled && isPreviewMode) {
      openFlyout({
        right,
        left
      });
    }
    // When not in preview mode, open left panel as usual
    else if (!isPreviewMode) {
      openLeftPanel(left);
    }
  }, [telemetry, openLeftPanel, isRiskScoreExist, scopeId, userName, email, hasMisconfigurationFindings, hasNonClosedAlerts, isNewNavigationEnabled, isPreviewMode, openFlyout, contextID]);
  return {
    openDetailsPanel,
    isLinkEnabled
  };
};
exports.useNavigateToUserDetails = useNavigateToUserDetails;