"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRiskScore = exports.initialResult = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _search_strategy = require("../../../../common/api/search_strategy");
var _use_risk_score_feature_status = require("./use_risk_score_feature_status");
var _helpers = require("../../../common/containers/helpers");
var _search_strategy2 = require("../../../../common/search_strategy");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var _exceptions = require("../../../common/utils/exceptions");
var _use_space_id = require("../../../common/hooks/use_space_id");
var _use_search_strategy = require("../../../common/containers/use_search_strategy");
var _use_risk_engine_status = require("./use_risk_engine_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialResult = exports.initialResult = {
  totalCount: 0,
  data: undefined
};
const useRiskScore = ({
  timerange,
  onlyLatest = true,
  filterQuery,
  sort,
  skip = false,
  pagination,
  riskEntity,
  includeAlertsCount = false
}) => {
  const spaceId = (0, _use_space_id.useSpaceId)();
  const {
    installed: isNewRiskScoreModuleInstalled,
    isLoading: riskScoreStatusLoading
  } = (0, _use_risk_engine_status.useIsNewRiskScoreModuleInstalled)();
  const defaultIndex = spaceId && !riskScoreStatusLoading && isNewRiskScoreModuleInstalled !== undefined ? riskEntity === _search_strategy2.EntityType.host ? (0, _search_strategy2.getHostRiskIndex)(spaceId, onlyLatest, isNewRiskScoreModuleInstalled) : (0, _search_strategy2.getUserRiskIndex)(spaceId, onlyLatest, isNewRiskScoreModuleInstalled) : undefined;
  const factoryQueryType = _search_strategy.EntityRiskQueries.list;
  const {
    querySize,
    cursorStart
  } = pagination || {};
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    isDeprecated,
    isEnabled,
    isAuthorized,
    isLoading: isDeprecatedLoading,
    refetch: refetchDeprecated
  } = (0, _use_risk_score_feature_status.useRiskScoreFeatureStatus)(riskEntity, defaultIndex);
  const {
    loading,
    result: response,
    search,
    refetch,
    inspect,
    error
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType,
    initialResult,
    abort: skip,
    showErrorToast: false
  });
  const refetchAll = (0, _react.useCallback)(() => {
    if (defaultIndex) {
      refetchDeprecated(defaultIndex);
      refetch();
    }
  }, [defaultIndex, refetch, refetchDeprecated]);
  const riskScoreResponse = (0, _react.useMemo)(() => ({
    data: response.data,
    inspect,
    refetch: refetchAll,
    totalCount: response.totalCount,
    isAuthorized,
    isDeprecated,
    isModuleEnabled: isEnabled,
    isInspected: false,
    error
  }), [inspect, isDeprecated, isEnabled, isAuthorized, refetchAll, response.data, response.totalCount, error]);
  const requestTimerange = (0, _react.useMemo)(() => timerange ? {
    to: timerange.to,
    from: timerange.from,
    interval: ''
  } : undefined, [timerange]);
  const riskScoreRequest = (0, _react.useMemo)(() => defaultIndex ? {
    defaultIndex: [defaultIndex],
    factoryQueryType,
    riskScoreEntity: riskEntity,
    includeAlertsCount,
    filterQuery: (0, _helpers.createFilter)(filterQuery),
    pagination: cursorStart !== undefined && querySize !== undefined ? {
      cursorStart,
      querySize
    } : undefined,
    sort,
    timerange: requestTimerange,
    alertsTimerange: includeAlertsCount ? requestTimerange : undefined
  } : null, [cursorStart, defaultIndex, factoryQueryType, filterQuery, querySize, sort, requestTimerange, riskEntity, includeAlertsCount]);
  (0, _react.useEffect)(() => {
    if (error) {
      if (!(0, _exceptions.isIndexNotFoundError)(error)) {
        addError(error, {
          title: _i18n.i18n.translate('xpack.securitySolution.riskScore.failSearchDescription', {
            defaultMessage: `Failed to run search on risk score`
          })
        });
      }
    }
  }, [addError, error]);
  (0, _react.useEffect)(() => {
    if (!skip && !isDeprecatedLoading && riskScoreRequest != null && isAuthorized && isEnabled && !isDeprecated) {
      search(riskScoreRequest);
    }
  }, [isEnabled, isDeprecated, isAuthorized, isDeprecatedLoading, riskScoreRequest, search, skip]);
  const result = {
    ...riskScoreResponse,
    loading: loading || isDeprecatedLoading
  };
  return result;
};
exports.useRiskScore = useRiskScore;