"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateDataView = void 0;
var _react = require("react");
var _kibana = require("../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This hook is used to create a data view from a data view spec.
 * It is used in the attack discovery pages and AI4DSOC pages to create a data view.
 * When skip is true, it does not create a data view.
 */
const useCreateDataView = ({
  dataViewSpec,
  loading = false,
  skip
}) => {
  const {
    dataViews
  } = (0, _kibana.useKibana)().services;
  const [dataView, setDataView] = (0, _react.useState)(undefined);
  const [dataViewLoading, setDataViewLoading] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => {
    let active = true;
    async function createDataView() {
      if (!loading) {
        try {
          const dv = await dataViews.create(dataViewSpec);
          if (active) {
            setDataView(dv);
            setDataViewLoading(false);
          }
        } catch {
          if (active) {
            setDataView(undefined);
            setDataViewLoading(false);
          }
        }
      }
    }
    if (!skip) {
      createDataView();
    }
    return () => {
      active = false;
    };
  }, [dataViewSpec, dataViews, loading, skip]);
  return {
    dataView,
    loading: dataViewLoading
  };
};
exports.useCreateDataView = useCreateDataView;