"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFindingsStats = exports.MisconfigurationsPreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _securitySolutionDistributionBar = require("@kbn/security-solution-distribution-bar");
var _use_has_misconfigurations = require("@kbn/cloud-security-posture/src/hooks/use_has_misconfigurations");
var _i18n = require("@kbn/i18n");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _analytics = require("@kbn/analytics");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _expandable_panel = require("../../../flyout/shared/components/expandable_panel");
var _left_panel_header = require("../../../flyout/entity_details/shared/components/left_panel/left_panel_header");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFindingsStats = (passedFindingsStats, failedFindingsStats) => {
  if (passedFindingsStats === 0 && failedFindingsStats === 0) return [];
  return [{
    key: _i18n.i18n.translate('xpack.securitySolution.flyout.right.insights.misconfigurations.passedFindingsText', {
      defaultMessage: 'Passed findings'
    }),
    count: passedFindingsStats,
    color: _cloudSecurityPosture.statusColors.passed
  }, {
    key: _i18n.i18n.translate('xpack.securitySolution.flyout.right.insights.misconfigurations.failedFindingsText', {
      defaultMessage: 'Failed findings'
    }),
    count: failedFindingsStats,
    color: _cloudSecurityPosture.statusColors.failed
  }];
};
exports.getFindingsStats = getFindingsStats;
const MisconfigurationPreviewScore = ({
  passedFindings,
  failedFindings,
  euiTheme
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, `${Math.round(passedFindings / (passedFindings + failedFindings) * 100)}%`))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    css: (0, _react2.css)`
              font-weight: ${euiTheme.font.weight.semiBold};
            `
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.insights.misconfigurations.postureScoreDescription",
    defaultMessage: "Posture score"
  })))));
};
const MisconfigurationsPreview = ({
  value,
  field,
  isPreviewMode,
  isLinkEnabled,
  openDetailsPanel
}) => {
  const {
    hasMisconfigurationFindings,
    passedFindings,
    failedFindings
  } = (0, _use_has_misconfigurations.useHasMisconfigurations)(field, value);
  (0, _react.useEffect)(() => {
    _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metrics.ENTITY_FLYOUT_WITH_MISCONFIGURATION_VISIT);
  }, []);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const goToEntityInsightTab = (0, _react.useCallback)(() => {
    openDetailsPanel({
      tab: _left_panel_header.EntityDetailsLeftPanelTab.CSP_INSIGHTS,
      subTab: _left_panel_header.CspInsightLeftPanelSubTab.MISCONFIGURATIONS
    });
  }, [openDetailsPanel]);
  const link = (0, _react.useMemo)(() => isLinkEnabled ? {
    callback: goToEntityInsightTab,
    tooltip: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.insights.misconfiguration.misconfigurationTooltip",
      defaultMessage: "Show all misconfiguration findings"
    })
  } : undefined, [isLinkEnabled, goToEntityInsightTab]);
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      iconType: !isPreviewMode && hasMisconfigurationFindings ? 'arrowStart' : '',
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        css: (0, _react2.css)`
              font-weight: ${euiTheme.font.weight.semiBold};
            `,
        "data-test-subj": 'securitySolutionFlyoutInsightsMisconfigurationsTitleText'
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.insights.misconfigurations.misconfigurationsTitle",
        defaultMessage: "Misconfigurations"
      })),
      link: hasMisconfigurationFindings ? link : undefined
    },
    "data-test-subj": 'securitySolutionFlyoutInsightsMisconfigurations'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(MisconfigurationPreviewScore, {
    passedFindings: passedFindings,
    failedFindings: failedFindings,
    euiTheme: euiTheme
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_securitySolutionDistributionBar.DistributionBar, {
    stats: getFindingsStats(passedFindings, failedFindings)
  }))))));
};
exports.MisconfigurationsPreview = MisconfigurationsPreview;