"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EXPLAIN_THEN_SUMMARIZE_SUGGEST_INVESTIGATION_GUIDE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EXPLAIN_THEN_SUMMARIZE_SUGGEST_INVESTIGATION_GUIDE = exports.EXPLAIN_THEN_SUMMARIZE_SUGGEST_INVESTIGATION_GUIDE = _i18n.i18n.translate('xpack.securitySolution.assistant.content.prompts.investigationGuide', {
  defaultMessage: `Evaluate the security event described above and provide a structured, markdown-formatted summary suitable for inclusion in an Elastic Security case. Ensure you're using all tools available to you. Your response must include:
1. Event Description
  - Summarize the event, including user and host risk scores from the provided context.
  - Reference relevant MITRE ATT&CK techniques, with hyperlinks to the official MITRE pages.
2. Triage Steps
  - List clear, bulleted triage steps tailored to Elastic Security workflows (e.g., alert investigation, timeline creation, entity analytics review).
  - Highlight any relevant detection rules or anomaly findings.
3. Recommended Actions
  - Provide prioritized response actions, including:
    - Elastic Defend endpoint response actions (e.g., isolate host, kill process, retrieve/delete file), with links to Elastic documentation.
    - Example ES|QL queries for further investigation, formatted as code blocks.
    - Example OSQuery Manager queries for further investigation, formatted as code blocks.
    - Guidance on using Timelines and Entity Analytics for deeper context, with documentation links.
4. MITRE ATT&CK Context
  - Summarize the mapped MITRE ATT&CK techniques and provide actionable recommendations based on MITRE guidance, with hyperlinks.
5. Documentation Links
  - Include direct links to all referenced Elastic Security documentation and MITRE ATT&CK pages.
Formatting Requirements:
  - Use markdown headers, tables, and code blocks for clarity.
  - Organize the response into visually distinct sections.
  - Use concise, actionable language.
  - Include relevant emojis in section headers for visual clarity (e.g., 📝, 🛡️, 🔍, 📚).
`
});