"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserMessage = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _userProfileComponents = require("@kbn/user-profile-components");
var _react2 = require("@emotion/react");
var _use_user_profile = require("../../hooks/use_user_profile");
var _copy_action_button = require("./copy_action_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserMessageCSS = (0, _react2.css)`
  white-space: break-spaces;
`;
const UserMessage = ({
  content,
  createdAt
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const currentUserProfile = (0, _use_user_profile.useUserProfile)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComment, {
    eventColor: "subdued",
    css: {
      '.euiCommentEvent__body': {
        backgroundColor: euiTheme.colors.emptyShade
      }
    },
    username: _i18n.i18n.translate('xpack.searchPlayground.chat.message.user.name', {
      defaultMessage: 'You'
    }),
    event: _i18n.i18n.translate('xpack.searchPlayground.chat.message.user.event', {
      defaultMessage: 'asked'
    }),
    timestamp: createdAt && _i18n.i18n.translate('xpack.searchPlayground.chat.message.user.createdAt', {
      defaultMessage: 'at {time}',
      values: {
        time: (0, _moment.default)(createdAt).format('HH:mm')
      }
    }),
    timelineAvatar: /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserAvatar, {
      user: currentUserProfile === null || currentUserProfile === void 0 ? void 0 : currentUserProfile.user,
      avatar: currentUserProfile === null || currentUserProfile === void 0 ? void 0 : currentUserProfile.data.avatar
    }),
    timelineAvatarAriaLabel: currentUserProfile === null || currentUserProfile === void 0 ? void 0 : currentUserProfile.user.username,
    actions: /*#__PURE__*/_react.default.createElement(_copy_action_button.CopyActionButton, {
      copyText: String(content),
      ariaLabel: _i18n.i18n.translate('xpack.searchPlayground.chat.message.user.copyLabel', {
        defaultMessage: 'Copy user message'
      })
    }),
    "data-test-subj": "userMessage"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: UserMessageCSS
  }, /*#__PURE__*/_react.default.createElement("p", null, content)));
};
exports.UserMessage = UserMessage;