"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showSaveModal = showSaveModal;
var _react = _interopRequireDefault(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _kibana_services = require("../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Represents the result of trying to persist the saved object.
 * Contains `error` prop if something unexpected happened (e.g. network error).
 * Contains an `id` if persisting was successful. If `id` and
 * `error` are undefined, persisting was not successful, but the
 * modal can still recover (e.g. the name of the saved object was already taken).
 */

function isSuccess(result) {
  return 'id' in result;
}

/**
 * Minimum props expected for model components passed to `showSaveModal`
 */

/**
 * @deprecated legacy modal display mechanism
 */
function showSaveModal(saveModal, Wrapper) {
  // initialize variable that will hold reference for unmount
  // eslint-disable-next-line prefer-const
  let unmount;
  const mount = (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(function createSavedObjectModal() {
    const closeModal = () => {
      unmount();
      // revert control back to caller after cleaning up modal
      setTimeout(() => {
        var _saveModal$props$onCl, _saveModal$props;
        (_saveModal$props$onCl = (_saveModal$props = saveModal.props).onClose) === null || _saveModal$props$onCl === void 0 ? void 0 : _saveModal$props$onCl.call(_saveModal$props);
      }, 0);
    };
    const onSave = saveModal.props.onSave;
    const onSaveConfirmed = async (...args) => {
      const response = await onSave(...args);
      // close modal if we either hit an error or the saved object got an id
      if (Boolean(isSuccess(response) ? response.id : response.error)) {
        closeModal();
      }
      return response;
    };
    const augmentedElement = /*#__PURE__*/_react.default.cloneElement(saveModal, {
      onSave: onSaveConfirmed,
      onClose: closeModal
    });
    return /*#__PURE__*/_react.default.createElement(Wrapper !== null && Wrapper !== void 0 ? Wrapper : _react.default.Fragment, {
      children: augmentedElement
    });
  }), (0, _kibana_services.getRendering)());
  unmount = mount(document.createElement('div'));
}