"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePacks = void 0;
var _reactQuery = require("@kbn/react-query");
var _constants = require("../../common/constants");
var _kibana = require("../common/lib/kibana");
var _constants2 = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePacks = ({
  isLive = false,
  pageIndex = 0,
  pageSize = 100,
  sortField = 'updated_at',
  sortOrder = 'desc'
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)([_constants2.PACKS_ID, {
    pageIndex,
    pageSize,
    sortField,
    sortOrder
  }], () => http.get('/api/osquery/packs', {
    version: _constants.API_VERSIONS.public.v1,
    query: {
      pageIndex,
      pageSize,
      sortField,
      sortOrder
    }
  }), {
    keepPreviousData: true,
    // Refetch the data every 10 seconds
    refetchInterval: isLive ? 10000 : false
  });
};
exports.usePacks = usePacks;