"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreatePack = void 0;
var _reactQuery = require("@kbn/react-query");
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _kibana = require("../common/lib/kibana");
var _common = require("../../common");
var _page_paths = require("../common/page_paths");
var _constants2 = require("./constants");
var _use_error_toast = require("../common/hooks/use_error_toast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCreatePack = ({
  withRedirect
}) => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    application: {
      navigateToApp
    },
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const setErrorToast = (0, _use_error_toast.useErrorToast)();
  return (0, _reactQuery.useMutation)(payload => http.post('/api/osquery/packs', {
    version: _constants.API_VERSIONS.public.v1,
    body: JSON.stringify(payload)
  }), {
    onError: error => {
      setErrorToast(error, {
        title: error.body.error,
        toastMessage: error.body.message
      });
    },
    onSuccess: payload => {
      var _payload$data$name, _payload$data;
      queryClient.invalidateQueries([_constants2.PACKS_ID]);
      if (withRedirect) {
        navigateToApp(_common.PLUGIN_ID, {
          path: _page_paths.pagePathGetters.packs()
        });
      }
      toasts.addSuccess(_i18n.i18n.translate('xpack.osquery.newPack.successToastMessageText', {
        defaultMessage: 'Successfully created "{packName}" pack',
        values: {
          packName: (_payload$data$name = (_payload$data = payload.data) === null || _payload$data === void 0 ? void 0 : _payload$data.name) !== null && _payload$data$name !== void 0 ? _payload$data$name : ''
        }
      }));
    }
  });
};
exports.useCreatePack = useCreatePack;