"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageTitleContent = PageTitleContent;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _kibana_react = require("../../../utils/kibana_react");
var _get_health_color = require("../helpers/get_health_color");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PageTitleContent({
  rule
}) {
  const {
    triggersActionsUi: {
      getRuleTagBadge: RuleTagBadge
    }
  } = (0, _kibana_react.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: (0, _get_health_color.getHealthColor)(rule.executionStatus.status)
  }, rule.executionStatus.status.charAt(0).toUpperCase() + rule.executionStatus.status.slice(1))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.observability.ruleDetails.lastUpdatedMessage', {
    defaultMessage: 'Last updated'
  })), "\xA0", BY_WORD, " ", rule.updatedBy, " ", ON_WORD, "\xA0", (0, _moment.default)(rule.updatedAt).format('ll'), " \u2003", /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.observability.ruleDetails.createdWord', {
    defaultMessage: 'Created'
  })), "\xA0", BY_WORD, " ", rule.createdBy, " ", ON_WORD, "\xA0", (0, _moment.default)(rule.createdAt).format('ll'))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  })), rule.tags.length > 0 && /*#__PURE__*/_react.default.createElement(RuleTagBadge, {
    tagsOutPopover: true,
    tags: rule.tags
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }));
}
const BY_WORD = _i18n.i18n.translate('xpack.observability.ruleDetails.byWord', {
  defaultMessage: 'by'
});
const ON_WORD = _i18n.i18n.translate('xpack.observability.ruleDetails.onWord', {
  defaultMessage: 'on'
});