"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MessageText = MessageText;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _esql_code_block = require("./esql_code_block");
var _anonymized_highlight = require("./anonymized_highlight");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ANIMATION_TIME = 1;
const cursorCss = (0, _css.css)`
  @keyframes blink {
    0% {
      opacity: 0;
    }
    50% {
      opacity: 1;
    }
    100% {
      opacity: 0;
    }
  }

  animation: blink ${ANIMATION_TIME}s infinite;
  width: 10px;
  height: 16px;
  vertical-align: middle;
  display: inline-block;
  background: rgba(0, 0, 0, 0.25);
`;
const Cursor = () => /*#__PURE__*/_react.default.createElement("span", {
  key: "cursor",
  className: (0, _classnames.default)(cursorCss, 'cursor')
});

// a weird combination of different whitespace chars to make sure it stays
// invisible even when we cannot properly parse the text while still being
// unique
const CURSOR = ` ᠎  `;
const loadingCursorPlugin = () => {
  const visitor = (node, parent) => {
    if ('children' in node) {
      const nodeAsParent = node;
      nodeAsParent.children.forEach(child => {
        visitor(child, nodeAsParent);
      });
    }
    if (node.type !== 'text' && node.type !== 'inlineCode' && node.type !== 'code') {
      return;
    }
    const textNode = node;
    const indexOfCursor = textNode.value.indexOf(CURSOR);
    if (indexOfCursor === -1) {
      return;
    }
    textNode.value = textNode.value.replace(CURSOR, '');
    const indexOfNode = parent.children.indexOf(textNode);
    parent.children.splice(indexOfNode + 1, 0, {
      type: 'cursor',
      value: CURSOR
    });
  };
  return tree => {
    visitor(tree);
  };
};
const esqlLanguagePlugin = () => {
  const visitor = (node, parent) => {
    if ('children' in node) {
      const nodeAsParent = node;
      nodeAsParent.children.forEach(child => {
        visitor(child, nodeAsParent);
      });
    }
    if (node.type === 'code' && node.lang === 'esql') {
      node.type = 'esql';
    } else if (node.type === 'code') {
      // switch to type that allows us to control rendering
      node.type = 'codeBlock';
    }
  };
  return tree => {
    visitor(tree);
  };
};
function MessageText({
  loading,
  content,
  onActionClick,
  anonymizedHighlightedContent
}) {
  const containerClassName = (0, _css.css)`
    overflow-wrap: anywhere;
  `;
  const {
    parsingPluginList,
    processingPluginList
  } = (0, _react.useMemo)(() => {
    const parsingPlugins = (0, _eui.getDefaultEuiMarkdownParsingPlugins)();
    const processingPlugins = (0, _eui.getDefaultEuiMarkdownProcessingPlugins)();
    const {
      components
    } = processingPlugins[1][1];
    processingPlugins[1][1].components = {
      ...components,
      anonymized: props => /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        "data-test-subj": "anonymizedContent"
      }, props.content),
      cursor: Cursor,
      codeBlock: props => {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_esql_code_block.CodeBlock, null, props.value), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m"
        }));
      },
      esql: props => {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_esql_code_block.EsqlCodeBlock, {
          value: props.value,
          lang: props.lang,
          actionsDisabled: loading,
          onActionClick: onActionClick
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m"
        }));
      },
      table: props => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTable, (0, _extends2.default)({}, props, {
        className: (0, _css.css)`
              .euiTableCellContent__text {
                white-space: normal;
              }
            `
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      })),
      th: props => {
        const {
          children,
          ...rest
        } = props;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, rest, children);
      },
      tr: props => /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, props),
      td: props => {
        const {
          children,
          ...rest
        } = props;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, (0, _extends2.default)({
          truncateText: true
        }, rest), children);
      }
    };
    return {
      parsingPluginList: [loadingCursorPlugin, esqlLanguagePlugin, ...parsingPlugins, _anonymized_highlight.anonymizedHighlightPlugin],
      processingPluginList: processingPlugins
    };
  }, [loading, onActionClick]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: containerClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    textSize: "s",
    parsingPluginList: parsingPluginList,
    processingPluginList: processingPluginList
  }, `${anonymizedHighlightedContent || content}${loading ? CURSOR : ''}`));
}