"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ForecastProgress = ForecastProgress;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _progress_icon = require("./progress_icon");
var _progress_states = require("./progress_states");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Renders the progress of the various actions involved in running a forecast on an ML job.
 */

function ForecastProgress({
  forecastProgress,
  jobOpeningState,
  jobClosingState
}) {
  return /*#__PURE__*/_react.default.createElement("div", null, jobOpeningState !== _progress_states.PROGRESS_STATES.UNSET && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.timeSeriesExplorer.forecastingModal.openingJobTitle",
    defaultMessage: "Opening job\u2026"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_progress_icon.ProgressIcon, {
    state: jobOpeningState
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), forecastProgress !== _progress_states.PROGRESS_STATES.UNSET && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.timeSeriesExplorer.forecastingModal.runningForecastTitle",
    defaultMessage: "Running forecast\u2026"
  }))), forecastProgress >= 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: forecastProgress + '%'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "l",
    value: forecastProgress,
    max: 100
  }))), forecastProgress === _progress_states.PROGRESS_STATES.ERROR && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_progress_icon.ProgressIcon, {
    state: _progress_states.PROGRESS_STATES.ERROR
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), jobClosingState !== _progress_states.PROGRESS_STATES.UNSET && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.timeSeriesExplorer.forecastingModal.closingJobTitle",
    defaultMessage: "Closing job\u2026"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_progress_icon.ProgressIcon, {
    state: jobClosingState
  })))));
}
ForecastProgress.propType = {
  forecastProgress: _propTypes.default.number,
  jobOpeningState: _propTypes.default.number,
  jobClosingState: _propTypes.default.number
};