"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTableSettings = useTableSettings;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_SIZE_OPTIONS = [10, 25, 50];

// Copying from EUI EuiBasicTable types as type is not correctly picked up for table's onChange
// Can be removed when https://github.com/elastic/eui/issues/4011 is addressed in EUI

/**
 *
 * @param totalItemCount
 * @param pageState
 * @param updatePageState
 * @param hide If true, hides pagination when total number of items is lower that the smallest per page option
 * @returns
 */
function useTableSettings(totalItemCount, pageState, updatePageState, hide = false) {
  const {
    pageIndex,
    pageSize,
    sortField,
    sortDirection
  } = pageState;
  const onTableChange = (0, _react.useCallback)(({
    page,
    sort
  }) => {
    var _page$index, _page$size, _sort$direction;
    let resultSortField = sort === null || sort === void 0 ? void 0 : sort.field;
    if (typeof resultSortField !== 'string') {
      resultSortField = pageState.sortField;
    }
    const result = {
      pageIndex: (_page$index = page === null || page === void 0 ? void 0 : page.index) !== null && _page$index !== void 0 ? _page$index : pageState.pageIndex,
      pageSize: (_page$size = page === null || page === void 0 ? void 0 : page.size) !== null && _page$size !== void 0 ? _page$size : pageState.pageSize,
      sortField: resultSortField,
      sortDirection: (_sort$direction = sort === null || sort === void 0 ? void 0 : sort.direction) !== null && _sort$direction !== void 0 ? _sort$direction : pageState.sortDirection
    };
    updatePageState(result);
  }, [pageState, updatePageState]);
  const pagination = (0, _react.useMemo)(() => {
    if (hide && totalItemCount <= Math.min(...PAGE_SIZE_OPTIONS)) {
      // Hide pagination if total number of items is lower that the smallest per page option
      return false;
    }
    return {
      pageIndex,
      pageSize,
      totalItemCount,
      pageSizeOptions: PAGE_SIZE_OPTIONS
    };
  }, [totalItemCount, pageIndex, pageSize, hide]);
  const sorting = (0, _react.useMemo)(() => ({
    sort: {
      field: sortField,
      direction: sortDirection
    }
  }), [sortField, sortDirection]);
  return {
    onTableChange,
    pagination,
    sorting
  };
}