"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _shared = require("../../shared");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PipelineDetails = exports.PipelineDetails = /*#__PURE__*/(0, _react.memo)(({
  handlePipelineConfigUpdate,
  modelId,
  pipelineName,
  pipelineNameError,
  pipelineDescription,
  targetField,
  targetFieldError
}) => {
  const handleConfigChange = (value, type) => {
    handlePipelineConfigUpdate({
      [type]: value
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_shared.PipelineDetailsTitle, {
    modelId: modelId
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_shared.PipelineNameAndDescription, {
    pipelineName: pipelineName,
    pipelineDescription: pipelineDescription,
    pipelineNameError: pipelineNameError,
    handlePipelineConfigUpdate: handlePipelineConfigUpdate
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.targetFieldLabel', {
      defaultMessage: 'Target field (optional)'
    }),
    helpText: !targetFieldError && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.targetFieldHelpText",
      defaultMessage: "Field used to contain inference processor results. Defaults to {targetField}.",
      values: {
        targetField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'ml.inference.<processor_tag>')
      }
    }),
    error: targetFieldError,
    isInvalid: targetFieldError !== undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    "data-test-subj": "mlTrainedModelsInferencePipelineTargetFieldInput",
    value: targetField,
    onChange: e => handleConfigChange(e.target.value, 'targetField')
  }))))));
});